/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class VWConfirmRefreshDialog
extends VWModalDialog {
    private boolean m_bCanCancel = true;
    private boolean m_bCanceled = false;
    private boolean m_bYes = true;
    private JTextArea m_infoTextArea = null;
    private JLabel m_warningIcon = null;
    private JButton m_yesButton = new JButton(VWResource.s_yes);
    private JButton m_noButton = new JButton(VWResource.s_no);
    private JButton m_cancelButton = new JButton(VWResource.s_cancel);

    public VWConfirmRefreshDialog(Frame parent, boolean bCanCancel) {
        super(parent);
        this.m_bCanCancel = bCanCancel;
        this.setupLayout();
    }

    public VWConfirmRefreshDialog(Frame parent) {
        this(parent, true);
    }

    public VWConfirmRefreshDialog(Dialog parent, boolean bCanCancel) {
        super(parent);
        this.m_bCanCancel = bCanCancel;
        this.setupLayout();
    }

    public VWConfirmRefreshDialog(Dialog parent) {
        this(parent, true);
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_confirmRefreshDialogDim);
        if (dim == null) {
            dim = new Dimension(330, 180);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_refresh);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        this.m_infoTextArea = new JTextArea(VWResource.s_refreshConfirmMessage);
        this.m_infoTextArea.setLineWrap(true);
        this.m_infoTextArea.setWrapStyleWord(true);
        this.m_infoTextArea.setOpaque(false);
        this.m_infoTextArea.setEditable(false);
        this.m_warningIcon = new JLabel(VWImageLoader.createImageIcon("warning.gif"));
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BoxLayout(iconPanel, 3));
        iconPanel.add(this.m_warningIcon);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_yesButton);
        buttonPanel.add(this.m_noButton);
        if (this.m_bCanCancel) {
            buttonPanel.add(this.m_cancelButton);
        }
        mainPanel.add((Component)this.m_infoTextArea, "Center");
        mainPanel.add((Component)iconPanel, "Before");
        mainPanel.add((Component)buttonPanel, "Last");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        this.m_yesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWConfirmRefreshDialog.this.m_bCanceled = false;
                VWConfirmRefreshDialog.this.m_bYes = true;
                VWConfirmRefreshDialog.this.setVisible(false);
            }
        });
        this.m_noButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWConfirmRefreshDialog.this.m_bCanceled = false;
                VWConfirmRefreshDialog.this.m_bYes = false;
                VWConfirmRefreshDialog.this.setVisible(false);
            }
        });
        if (this.m_bCanCancel) {
            this.m_cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWConfirmRefreshDialog.this.m_bCanceled = true;
                    VWConfirmRefreshDialog.this.setVisible(false);
                }
            });
        }
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_infoTextArea.setFont(boldFont);
        }
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public boolean isYes() {
        return this.m_bYes;
    }
}

